package jp.mosp.common.part;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.common.CommonConst;
import jp.mosp.system.dao.MWorkTypeDao;
import jp.mosp.system.dto.MWorkTypeDto;

/**
 * Ζ`ԂɊւPartNX
 * @author yoshida
 *	@version	0.0.1
 */
public class WorkTypePart extends BasePart {

	/**
	 * RXgN^
	 */
	public WorkTypePart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public WorkTypePart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * CM_WORKTYPEe[upDAO̎擾
	 * @return	ςMWorkTypeDaoCX^X
	 * @throws Exception
	 */
	public MWorkTypeDao getMWorkTypeDao() throws Exception {
		return (MWorkTypeDao)getPreparedDao(MWorkTypeDao.class.getCanonicalName());
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	public String[][] getWorkTypeArrayNotDeleted() throws Exception {
		// ̎擾
		List<MWorkTypeDto> listWorkType = getMWorkTypeDao().findAvailable();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		return aryWorkType;
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)iTxtj
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	public String[][] getWorkTypeArrayWithWeekHoliday() throws Exception {
		// ̎擾
		List<MWorkTypeDto> listWorkType = getMWorkTypeDao().findAvailable();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		aryWorkType = StringPart.addArrayLastRowValue(aryWorkType,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		return aryWorkType;
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	public String[][] getWorkTypeArrayAll() throws Exception {
		// ̎擾
		List<MWorkTypeDto> listWorkType = getMWorkTypeDao().findAll();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		return aryWorkType;
	}

	/**
	 * Ζ`ԃR[h擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	public String[][] getWorkTypeArrayAllWithWeekHoliday() throws Exception {
		// ̎擾
		List<MWorkTypeDto> listWorkType = getMWorkTypeDao().findAll();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][2];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
		}
		aryWorkType = StringPart.addArrayLastRowValue(aryWorkType,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY,
				CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY);
		return aryWorkType;
	}

	/**
	 * Ζ`ԏ擾(CM_WORKTYPE)
	 * @return Ζ`ԃR[hXg
	 * @throws Exception 
	 */
	public String[][] getWorkTypeDataArray() throws Exception {
		// ̎擾
		List<MWorkTypeDto> listWorkType = getMWorkTypeDao().findAll();
		// z̍쐬
		String[][] aryWorkType = new String[listWorkType.size()][8];
		for (int i = 0; i < listWorkType.size(); i++) {
			aryWorkType[i][0] = listWorkType.get(i).getShiftCode();
			aryWorkType[i][1] = listWorkType.get(i).getShiftName();
			aryWorkType[i][2] = String.valueOf(listWorkType.get(i).getStartTime());
			aryWorkType[i][3] = String.valueOf(listWorkType.get(i).getQuitTime());
			aryWorkType[i][4] = String.valueOf(listWorkType.get(i).getWorkTime());
			aryWorkType[i][5] = String.valueOf(listWorkType.get(i).getBreakTime());
			aryWorkType[i][6] = String.valueOf(listWorkType.get(i).getOverStart());
			aryWorkType[i][7] = String.valueOf(listWorkType.get(i).getOverBreak());
		}
		return aryWorkType;
	}

	/**
	 * Ζ`ԃXg擾(CM_WORKTYPE)
	 * @return Ζ`ԃXg
	 * @throws Exception 
	 */
	public Map<String, MWorkTypeDto> getWorkTypeMap() throws Exception {
		// ̎擾
		List<MWorkTypeDto> listWorkType = getMWorkTypeDao().findAll();
		// Map̍쐬
		HashMap<String, MWorkTypeDto> map = new HashMap<String, MWorkTypeDto>();
		for (int i = 0; i < listWorkType.size(); i++) {
			map.put(listWorkType.get(i).getShiftCode(), listWorkType.get(i));
		}
		return map;
	}

}
